module net.BurtonRadons.digstrip.platform.fileSelector;


class FileSelector
{
    private import net.BurtonRadons.digstrip.platform.control;
    private import net.BurtonRadons.digstrip.platform.windows;
    
    /** An individual filter registered with addFilter. */
    struct Filter
    {
        char [] desc; /**< The descriptive name of the filter. */
        char [] pattern; /**< The semi-colon-separated wildcard pattern, case-insensitive. */
    };

    Filter [] filters; /**< The list of filters registered with addFilter. */
    int defaultFilter; /**< The default filter index, 0 for the custom filter, or an index into filters plus one. */
    Filter custom; /**< The custom filter that holds what filter the user enters into the selection editor. */
    char [] title; /**< The text to use in the title bar of the selector, or null for some default. */
    char [] filename; /**< The default filename to insert in the edit box. */

    bit multiSelect = false; /**< Whether this is a multiple-file selector */
    bit createPrompt = false; /**< If the user selects a file that doesn't exist, whether to give an "Are you sure?" message */
    bit fileMustExist = true; /**< Display a warning if the user selects a nonexistent file */
    bit showReadOnly = false; /**< Show a read-only checkbox */
    bit overwritePrompt = false; /**< If this is a save dialog, ask whether the user wants to overwrite this */
    bit pathMustExist = true; /**< Display a warning if the user selects a nonexistent path */
    bit save = false; /**< Save mode if true, open mode if false */

    /** Set save mode. */
    this (bit save) { this.save = save; }

}
